﻿namespace Code6587EN.Ch07.Controls
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Utilities;
    using System.Web.UI;

    /// <summary>
    /// ASP.NET user control to register analytics script blocks at the end of the form element
    /// on the page.
    /// </summary>
    public class CustomAnalyticsCode : UserControl
    {
        // The name of the property we will store on the root site of the site collection
        private const string PropertyName = "CustomAnalyticsCode";

        // Override the CreateChildControls method to add our analytics code
        protected override void CreateChildControls()
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomAnalyticsCode::CreateChildControls"))
            {
                // If the RootWeb of the current Site Collection contains the analytics code property, 
                // add it to the page at the end of the form element
                if (SPContext.Current.Site.RootWeb.AllProperties.ContainsKey(PropertyName)
                    && !string.IsNullOrEmpty(SPContext.Current.Site.RootWeb.AllProperties[PropertyName].ToString()))                        
                    this.Page.Form.Controls.Add(new LiteralControl(SPContext.Current.Site.RootWeb.AllProperties[PropertyName].ToString()));
            }
        }
    }
}
